/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.certs;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.certs.CertMgtConstants;
import com.ibm.hwmca.fw.certs.CertMgtPanelUtils;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.msgpanel.CommonMsgApp;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.DataBean;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.UserTaskManager;
import com.ibm.ui.framework.ValueDescriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

public class ListBoxBean
extends PanelBean
implements DataBean,
CertMgtConstants {
    private static final String TRACE_MASKD = "XCRTLBBD";
    private static final String TRACE_MASKF = "XCRTLBBF";
    private static final String TRACE_MASKT = "XCRTLBBT";
    private boolean requireChoice;
    private boolean multipleSelectionsAllowed;
    private ArrayList choices;
    private Serializable opaqueObject;
    private LocalizableText introLabel;
    private String m_sIntroLabel;
    private String m_sListBox;
    private ValueDescriptor[] m_vdListBox;
    private ValueDescriptor[] m_vdListBoxSelection;

    public ListBoxBean(LocalizableText introLabel, ArrayList choices, Serializable opaqueObject, boolean requireChoice, boolean multipleSelectionsAllowed, String name) throws HException {
        String choice = null;
        this.introLabel = introLabel;
        this.requireChoice = requireChoice;
        this.multipleSelectionsAllowed = multipleSelectionsAllowed;
        if (choices != null && choices.size() > 0) {
            Iterator i = choices.iterator();
            while (i.hasNext()) {
                choice = (String)i.next();
                if (choice != null && choice.length() != 0) continue;
                throw new HException("Choice is null or empty.");
            }
        } else {
            throw new HException("Choice list is empty.");
        }
        this.choices = choices;
        this.opaqueObject = opaqueObject;
        this.setBeanName(name);
        Trace.trace(TRACE_MASKT, "<->ListBoxBean(" + introLabel + ", " + choices + ", " + opaqueObject + ", " + name + ")");
    }

    public void setIntroLabel(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "<->setIntrolLabel(" + s + ")");
        this.m_sIntroLabel = s;
    }

    public String getIntroLabel() {
        Trace.trace(TRACE_MASKT, "<->getIntrolLabel() returning " + this.m_sIntroLabel);
        return this.m_sIntroLabel;
    }

    public ValueDescriptor[] getListBoxList() {
        Trace.trace(TRACE_MASKT, "<->getListBoxList() returning " + this.m_vdListBox);
        return this.m_vdListBox;
    }

    public void setListBox(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "<->setListBox(" + s + ")");
        this.m_sListBox = s;
    }

    public String getListBox() {
        Trace.trace(TRACE_MASKT, "<->getListBox() returning " + this.m_sListBox);
        return this.m_sListBox;
    }

    public void setListBoxSelection(ValueDescriptor[] selected) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "<->setListBoxSelection(" + selected + ")");
        this.m_vdListBoxSelection = selected;
    }

    public ValueDescriptor[] getListBoxSelection() {
        Trace.trace(TRACE_MASKT, "<->getListBoxSelection() returning " + this.m_vdListBoxSelection);
        return this.m_vdListBoxSelection;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void load() {
        int index = 0;
        this.setIntroLabel(this.introLabel.toString());
        this.m_vdListBox = new ValueDescriptor[this.choices.size()];
        index = 0;
        Iterator i = this.choices.iterator();
        while (i.hasNext()) {
            this.m_vdListBox[index++] = CertMgtPanelUtils.createValueDescriptor("ListBox", (String)i.next());
        }
        this.m_sListBox = "";
    }

    public void save() {
    }

    public void panelAction(TaskActionEvent event) {
        String elementName = null;
        String actionCommand = null;
        UserTaskManager utm = null;
        Object choices = null;
        String[] choicesAsStrings = null;
        Trace.trace(TRACE_MASKT, "->panelAction() : \n\tBean Name     : " + this.getBeanName() + "\n\tCurrentElement: " + event.getCurrentElement() + "\n\tElementName   : " + event.getElementName() + "\n\tActionCommand : " + event.getActionCommand());
        if (event != null) {
            elementName = event.getElementName();
            actionCommand = event.getActionCommand();
            utm = this.getUserTaskManager();
            if (actionCommand.equals("ListBoxOKButton")) {
                String choice = null;
                choice = this.getListBox();
                if (choice != null) {
                    choicesAsStrings = new String[]{choice};
                    CertMgtPanelUtils.sendTaskletRequest(actionCommand, (Serializable)choicesAsStrings, this.opaqueObject, null, this);
                } else if (this.requireChoice) {
                    if (utm != null) {
                        try {
                            CommonMsgApp.showMessageBox(utm, new LocalizableText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0012"), new MessageText("com/ibm/hwmca/fw/certs/res/CertMgtText", "0048"), MsgType.ERROR_MESSAGE);
                        }
                        catch (HException e) {
                            new FrameworkLog(CertMgtConstants.LOG_INFO, 4, e).log();
                        }
                    }
                } else {
                    CertMgtPanelUtils.sendTaskletRequest(actionCommand, null, this.opaqueObject, null, this);
                }
            } else if (elementName.equals("CancelButton")) {
                CertMgtPanelUtils.sendCancelRequest(this);
            } else {
                Trace.trace(TRACE_MASKF, "Unknown event received in panelAction(...) : " + actionCommand);
                new FrameworkLog(CertMgtConstants.LOG_INFO, 7).log();
            }
        }
        Trace.trace(TRACE_MASKT, "<-panelAction(...)");
    }
}

